# -*- coding: utf-8 -*-
"""
Created on Thu Aug 13 10:11:16 2015

@author: remcholab
"""

#################################
############USER NOTES###########
#################################
#TROUBLESHOOTING
    #If experiencing errors using the *.exe file, please verify the program is being run on Win7 64-bit.
    #If still experiencing errors, install Anaconda for Python 3.4 or higher from www.continuum.io
        #Install necessary modules using the included Anaconda command prompt: <conda install tk>, <conda install serial>, etc.
    #Run this script using the included IDE, Spyder.
    #If running this script from an IDE, remember to refresh consoles between experiments.
    #Leaving detector plugged in for excessive periods (longer than 20min) without resetting results in errors due to overly high bit-counts.

#################################
##########IMPORT MODULES#########
#################################
import serial, re, matplotlib, os
import tkinter as tk
import numpy as np
matplotlib.use('Agg') #this and the last line only necessary to help generate *.exe
import matplotlib.pyplot as plt
import matplotlib.pylab as plb

#################################
##CREATE/ENTER OUTPUT DIRECTORY##
#################################
#The block below checks if the program is running...
#...via an *.exe file and if there is already an...
#...experimental data folder.  It creates folders...
#...and changes working directories as necessary.
if os.path.exists('imageformats'):
    os.chdir('..\..')
if not os.path.exists('experimental_data'):
    os.makedirs('experimental_data')
os.chdir('experimental_data')

#################################
##CREATING ENTRY FIELDS FOR GUI##
#################################
root = tk.Tk()
root.title('C4D User Input')

label1 = tk.Label(text='experiment time in seconds [default = 1]')
label1.pack(side=tk.TOP,padx=10)
entry1 = tk.Entry(root, width=10)
entry1.pack(side=tk.TOP,padx=10)

label2 = tk.Label(text='data file (no extension) in working directory [default = temp]')
label2.pack(side=tk.TOP,padx=10)
entry2 = tk.Entry(root, width=10)
entry2.pack(side=tk.TOP,padx=10)

label3 = tk.Label(text='COM port [default = COM3]')
label3.pack(side=tk.TOP,padx=10)
entry3 = tk.Entry(root, width=10)
entry3.pack(side=tk.TOP,padx=10)

note1 = tk.Label(text='\n\nCOPY THE FOLLOWING FIELDS FROM ARDUINO SCRIPT:')
note1.pack(side=tk.TOP,padx=10)

label4 = tk.Label(text='microcontroller signal interval in milliseconds [default = 10]')
label4.pack(side=tk.TOP,padx=10)
entry4 = tk.Entry(root, width=10)
entry4.pack(side=tk.TOP,padx=10)

label5 = tk.Label(text='baud rate [default = 115200]')
label5.pack(side=tk.TOP,padx=10)
entry5 = tk.Entry(root, width=10)
entry5.pack(side=tk.TOP,padx=10)
    
#################################
########MAIN PROGRAM LOOP########
#################################
def onok():
    
    #################################
    ######USER SPECIFIED VALUES######
    #################################
    if (entry1.get() != ''):
        expTime = float(entry1.get())
    else:
        expTime = 1
    if (entry2.get() != ''):
        prefix = entry2.get()
    else:
        prefix = 'temp'
        file = prefix + '.tsv'
        graph = prefix + '.pdf'
    if (entry3.get() != ''):
        port = entry3.get()
    else:
        port = 'COM3'
    if (entry4.get() != ''):
        delay = int(entry4.get())
    else:
        delay = 10 #in ms (copied from Arduino)
    if (entry5.get() != ''):
        baud = int(entry5.get())
    else:
        baud = 115200    
                                            
    #################################
    ####READ SIGNAL FROM ARDUINO#####
    #################################
    ser = serial.Serial(port, baud)
    data = []
    Delay = delay/1000 #in seconds
    numSignals = expTime/Delay #5 is signal delay from Arduino script.
    count = 0
    while count<numSignals: #quits after experiment time (expTime) expired.
        count = count + 1
        datum = ser.readline() #gets info from Teensy3.1
        data.append(datum)              
    ser.close() #closes port
    
    #################################
    ####PARSING & PRINTING DATA######
    #################################
    fh = open(file, 'w') #opens file handle
    for datum in data:
        datum = str(datum) #converts ASCII Arduino format to unicode
        datum = datum.split("\\t") #splits x vs. y axis values
        time = re.sub("[^0-9.]","",datum[0]) #removes formatting from value
        signal = re.sub("[^0-9.]","",datum[1]) #removes formatting from value
        print(time,'\t',signal, file=fh) #this format matches serial capture from Realterm terminal emulator
    fh.close()
    
    #################################
    ############GRAPHING#############
    #################################
    data = np.loadtxt(file) #for reading text file
    x = data[:,0]
    y = data[:,1]
    plt.plot(x,y) #would be nice to figure out how to change color
    plt.xlabel('time [ms]')
    plt.ylabel('signal [mV]')
    plb.savefig(graph)
    root.destroy() #closes window

#################################
####RUN MAIN LOOP & CALL CLASS###
#################################
tk.Button(root, text='OK', command=onok).pack(side=tk.RIGHT,padx=10,pady=10)
root.mainloop()