////////////////////////////
////////USER NOTES//////////
////////////////////////////
//Place this script in a directory with an identical name.
//Install Arduino from https://www.arduino.cc/en/Main/Software
//Install Teensyduino from https://www.pjrc.com/teensy/td_download.html
//Follow instructions on the page above to install driver for microcontroller.
//Upload this program to microcontroller
//Plug device in via USB cable.
//Open serial connection using method of your choice.

////////////////////////////
//INITIALIZATION AND SETUP//
////////////////////////////
float Time = 0; //initializes time
float Delay = 10; //The selected baud rate divided by the maximum number of bits in a signal (~120) is ~960 signals/s.  1/960=1.04, so 10 chosen.

void setup() {
  // put your setup code here, to run once:
  analogWriteResolution(12);  // realTerm only goes to 8 bits?
  Serial.begin(115200); //This baud rate is the maximum recommended for Teensy3.1 to avoid exessive error (pjrc.com)
}

////////////////////////////
////READING SIGNAL ONLY/////
////////////////////////////
//If this block commented out, program is in read/write mode shown in the "READ/WRITE (DEVELOPMENT)" block below.
//void loop() {
//  // read the input on analog pin 0:
//  int sensorValue = analogRead(A0);
//  Serial.print(Time);
//  Serial.print('\t');
//  Serial.print(sensorValue); //1053 max value
//  Serial.println();
//  delay(Delay);
//  Time = Time + Delay;
//}

////////////////////////////
//READ/WRITE (DEVELOPMENT)//
////////////////////////////
//If using this code, comment out the "READING SIGNAL ONLY" block.
//This code is to help develop front-end software, and asks microcontroller to read its own signal.
float Phase = 0.0;
float twopi = 3.14159 * 2;
elapsedMicros usec = 0;

void loop() {
  // read the input on analog pin 0:
  int sensorValue = analogRead(A0);
  float val = sin(Phase) * 2000.0 + 2050.0;
  // Use A14 pin for true analog output (source: pjrc.com)
  analogWrite(A14, (int)val);

  //The following code is from pjrc.com
  Phase = Phase + 0.02;
  if (Phase >= twopi) Phase = 0;
  while (usec < 500) ; // wait
  usec = usec - 500;
  
  Serial.print(Time);
  Serial.print('\t');
  Serial.print(sensorValue); //1053 max value
  Serial.println();
  delay(Delay);
  Time = Time + Delay;
}
