# -*- coding: utf-8 -*-
"""
Created on Thu Aug 13 10:11:16 2015

@author: remcholab
"""

#################################
############USER NOTES###########
#################################
#This program was run on Win7 / Python3.4 using Anaconda to compile necessary modules.
#Remember to start new console before beginning experiment!
#Remember to re-plug detector before experiment to reduce signal bit count from excessive # seconds.

#################################
######USER SPECIFIED VALUES######
#################################
delay = 10 #copy from Arduino script, in milliseconds
expTime = 5*60 #in seconds #USER SPECIFIED
file = 'temp.tsv' #USER SPECIFIED...goes in working directory
graph = 'temp.pdf' #USER SPECIFIED...goes in working directory
debug = 100 #sets low number of iterations for debugging only

#################################
####READ SIGNAL FROM ARDUINO#####
#################################
import serial #installed w/ Anaconda
data = []
Delay = delay/1000 #in seconds
numSignals = expTime/Delay #5 is signal delay from Arduino script.
ser = serial.Serial()
ser.port = 2 #this selects COM3 on windows7
ser.baudrate = 115200 #See notes in Arduino script.
ser.open() #opens port
count = 0
while count<debug: #for debug only; comment-out next line
#while count<numSignals: #quits after experiment time (expTime) expired.
    count = count + 1
    datum = ser.readline() #gets info from Teensy3.1
    data.append(datum)
ser.close() #closes port

#################################
####PARSING & PRINTING DATA######
#################################
import re #comes w/ Anaconda
fh = open(file, 'w') #opens file handle
for datum in data:
    datum = str(datum) #converts ASCII Arduino format to unicode
    datum = datum.split("\\t") #splits x vs. y axis values
    time = re.sub("[^0-9]","",datum[0]) #removes formatting from value
    signal = re.sub("[^0-9]","",datum[1]) #removes formatting from value
    print(time + '\t' + signal, file=fh) #same format delivered by Realterm, in which case this script up to now is unnecessary
fh.close()

#################################
############GRAPHING#############
#################################
import matplotlib.pyplot as plt #comes w/ Anaconda
import matplotlib.pylab as plb #comes w/ Anaconda
import numpy as np #comes w/ Anaconda
data = np.loadtxt(file) #for reading text file
x = data[:,0]
y = data[:,1]
fig = plt.plot(x,y) #would be nice to figure out how to change color
plt.xlabel('time [ms]')
plt.ylabel('signal [mV]')
plb.savefig(graph)