/*
 * Generates a signal and then reads it to help develop detector software.
 * The output from this program is designed to be read either by Realterm or Spyder (custom Python script)
 */

float Phase = 0.0;
float twopi = 3.14159 * 2;
elapsedMicros usec = 0;
float Time = 0; //initializes time
float Delay = 10; //The selected baud rate divided by the maximum number of bits in a signal (~120) is ~960 signals/s.  1/960=1.04, so 10 chosen.

void setup() {
  // put your setup code here, to run once:
  analogWriteResolution(12);  // realTerm only goes to 8 bits?
  Serial.begin(115200); //This baud rate is the maximum recommended for Teensy3.1 to avoid exessive error (pjrc.com)
}

void loop() {
  // read the input on analog pin 0:
  int sensorValue = analogRead(A0);
  float val = sin(Phase) * 2000.0 + 2050.0;
  analogWrite(A14, (int)val);
  // Use A14 pin for true analog output (source: pjrc.com)
  Phase = Phase + 0.02;
  if (Phase >= twopi) Phase = 0;
  while (usec < 500) ; // wait
  usec = usec - 500;
  Serial.print(Time);
  Serial.print('\t');
  Serial.print(sensorValue); //1053 max value
  Serial.println();
  delay(Delay);
  Time = Time + Delay;
}
