/*
 * Talking to Myself
 * Generates a signal and then reads it.  The purpose of this program is to serve as a basis for a later program that reads a signal from a function generator, and then a future program that reads a signal from a C4D.
 */

float Phase = 0.0;
float twopi = 3.14159 * 2;
elapsedMicros usec = 0;
float Time = 0;
float Delay = 10;

void setup() {
  // put your setup code here, to run once:
  analogWriteResolution(12);  // realTerm only goes to 8 bits?
  Serial.begin(9600); //remember to match this to realTerm
}

void loop() {
  // read the input on analog pin 0:
  int sensorValue = analogRead(A0);
  float val = sin(Phase) * 2000.0 + 2050.0;
  analogWrite(A14, (int)val);
  // Use A14 pin for true analog output (source: pjrc.com)
  Phase = Phase + 0.02;
  if (Phase >= twopi) Phase = 0;
  while (usec < 500) ; // wait
  usec = usec - 500;
  Serial.print(Time);
  Serial.print('\t');
  Serial.print(sensorValue);
  Serial.println();
  delay(Delay);
  Time = Time + Delay;
}
