/* 
:::::::::::::Introduction::::::::::::::::::::::::::::::::::::::::
This is one of the light examples you will find for controlling the MCP3201 with an Arduino UNO.
All the info you need is in this file and at Arduino's reference page.  This code will
tell the MCP3201 to read in an analog voltage and send out the value out over serial.

:::::::::::::from datasheet:For the MCP3201, 8-PDIP::::::::::::::
Pin  Name   Function
1    Vref   Positive voltage reference for input (typically 5v, tied to Vss)
2    IN+    Analog voltage input signal (ADC)
3    IN-    Analog voltage input ground (can be tied to power ground)
4    Vss    Power ground
5    CS     chip select, held low for the duration of a write command
6    Dout   Serial/SPI data output from MCP3201
7    SCK    clock signal from arduino when data is being sent
8    Vouta  Power supply (max 6.5v)

bit 12-1, D12:D1: ADC Data bits:
  12 bit number “D” which sets the output value. Contains a value between 0 and 4095
  
All other SPI data bits (D15, D14, D13, and D0) do nothing can can be ignored

::::::::::from Arduino Refernce page for SPI:::::::::::::::::::::::::::::::::
Every SPI device has a maximum allowed speed for SPI Bus. The SPI.setClockDivider()
allows you to change the clock speed to make your device working properly (default is 4MHz).
These pins support SPI communication using the SPI library (DUO):
SPI: 10 (SS), 11 (MOSI), 12 (MISO), 13 (SCK). 

::::::::::How to hook up the MCP3021 to the Teensy 3.1:::::::::::::::::::::::::::::::::::::
MCP3021, 8-PDIP
Pin  Name  ---> Arduino Connection
1    Vref  ---> 5 volt refernce - can come from Arduino 5V pin
2    IN+   ---> Analog voltage input signal (ADC) 
3    IN-   ---> Ground 
4    Vss   ---> Ground
5    CS    ---> Teensy pin 10
6    Dout  ---> Teensy pin 12
7    SCK   ---> Teensy pin 13
8    Vdd   ---> 5 volt power supply - can come from Arduino 5V pin

*/
#include <SPI.h>
#include <MCP3551.h>

const int MCPPin = 10;
MCP3551 myADC(MCPPin);
byte inByte = 0;
float Delay = 200;
float Time = 0;    

void setup() {
  Serial.begin(115200);
}

void loop() {
  if(myADC.getCode())
  {
    Serial.print(Time);
    Serial.print('\t');
    Serial.println(myADC.byteCode);               //Send the analog value out over serial (0 to 4095)
    delay(Delay);
    Time = Time + Delay;
  }

}
